package com.ejie.ab04b.service.platea;

import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.exception.AB04BParseException;
import com.ejie.ab04b.info.InfoProcedureFDCDP;
import com.ejie.ab04b.model.ComunicacionProcedimiento;
import com.ejie.ab04b.service.BuzonService;
import com.ejie.ab04b.util.PPSUtils;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.ab04b.webservice.client.q99mpps.Q99MPPSFacadeWSSoap;
import com.ejie.ctfm.xml.ApplicantInfo;
import com.ejie.ctfm.xml.ContextSubmission;
import com.ejie.foldermanagement.xml.RequestReturn;
import com.ejie.sc.xml.ConsultationContext;

/**
 * @author GFI-NORTE
 * 
 */
@Service()
abstract class PPSService {

	@Autowired()
	private BuzonService buzonService;

	@Autowired()
	private Q99MPPSFacadeWSSoap q99mPPSFacadeWSSoap;
	@Autowired()
	private InfoProcedureFDCDP infoProcedure;
	@Autowired()
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * BuzonService.
	 *
	 * @return the buzon service
	 */
	public BuzonService getBuzonService() {
		return this.buzonService;
	}

	/**
	 * ReloadableResourceBundleMessageSource.
	 *
	 * @return the app message source
	 */
	public ReloadableResourceBundleMessageSource getAppMessageSource() {
		return this.appMessageSource;
	}

	/**
	 * procedureId String ContextSubmission.
	 *
	 * @param procedureId
	 *            the procedure id
	 * @return the context submission
	 */
	public ContextSubmission crearContextSubmission(String procedureId) {
		infoProcedure.cargarInfoProcedures();
		ContextSubmission ctxSubmission = new ContextSubmission();

		ConsultationContext objContext = this.infoProcedure
				.getInfoProcedure(procedureId);

		// Se rellena la informacion obtenida del InfoProcedure
		PPSUtils.getInstance().addContextSubmissionFromInfoProcedure(
				ctxSubmission, objContext);

		ctxSubmission.setAuditUser(UtilSeguridad.getInstance().getAuditUser());

		ctxSubmission.setMustRegistry(Constantes.VALUE_SI);

		ctxSubmission.getDataControl()
				.addAll(PPSUtils.getInstance().getListDataControl());

		return ctxSubmission;

	}

	/**
	 * contextSubmission ContextSubmission RequestReturn.
	 *
	 * @param contextSubmission
	 *            the context submission
	 * @return the request return
	 * @throws AB04BParseException
	 *             the AB 04 B parse exception
	 */
	public RequestReturn enviarSolicitudPresencial(
			ContextSubmission contextSubmission) throws AB04BParseException {

		String sessionToken = UtilSeguridad.getInstance().getTokenXLNets();

		String scontextSubmission = PPSUtils.getInstance()
				.getContextSubmissionAsString(contextSubmission);

		scontextSubmission = scontextSubmission.replaceAll(
				"<\\?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"\\?>",
				"");
		scontextSubmission = scontextSubmission
				.replaceAll("xmlns:ns2=\"com/ejie/platea/generic/xml\"", "");
		scontextSubmission = scontextSubmission
				.replaceAll("xmlns=\"com/ejie/ctfm/xml\"", "");
		scontextSubmission = scontextSubmission.replaceAll("ns2:", "");
		scontextSubmission = scontextSubmission
				.replaceAll("xmlns=\"com/ejie/platea/generic/xml\"", "");
		scontextSubmission = scontextSubmission.replaceAll(
				"xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"",
				"");

		String response = this.q99mPPSFacadeWSSoap
				.sendEjgvDocumentPresencial(sessionToken, scontextSubmission);

		response = response.replaceAll("<RequestReturn>",
				"<RequestReturn xmlns=\"com/ejie/folderManagement/xml\">");

		return PPSUtils.getInstance().getPPSAsRequestReturn(response);

	}

	/**
	 * contextSubmission ContextSubmission RequestReturn.
	 *
	 * @param contextSubmission
	 *            the context submission
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	public void enviarAportacionPresencial(ContextSubmission contextSubmission)
			throws AB04BException {
		try {
			String sessionToken = UtilSeguridad.getInstance().getTokenXLNets();

			String scontextSubmission = PPSUtils.getInstance()
					.getContextSubmissionAsString(contextSubmission);

			scontextSubmission = scontextSubmission.replaceAll(
					"<\\?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"\\?>",
					"");
			scontextSubmission = scontextSubmission.replaceAll(
					"xmlns:ns2=\"com/ejie/platea/generic/xml\"", "");
			scontextSubmission = scontextSubmission
					.replaceAll("xmlns=\"com/ejie/ctfm/xml\"", "");
			scontextSubmission = scontextSubmission.replaceAll("ns2:", "");
			scontextSubmission = scontextSubmission
					.replaceAll("xmlns=\"com/ejie/platea/generic/xml\"", "");
			scontextSubmission = scontextSubmission.replaceAll(
					"xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"",
					"");

			this.q99mPPSFacadeWSSoap
					.sendEjgvDocumentAttachmentReceiverPresencial(sessionToken,
							scontextSubmission);
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Agrega al objeto ContextSubmission la informacion de registrySenderid,
	 * registrySenderName, senderId y senderName. Esta informacion depende del
	 * solicitante
	 * 
	 * ctxSubmission ContextSubmission comunicacion ComunicacionProcedimiento
	 *
	 * @param ctxSubmission
	 *            the ctx submission
	 * @param comunicacion
	 *            the comunicacion
	 */
	protected abstract void addContextSubmissionFromSolicitante(
			ContextSubmission ctxSubmission,
			ComunicacionProcedimiento comunicacion);

	/**
	 * Crea el apartado applicantInfo del contextSubmission de una solicitud
	 * 
	 * comunicacion ComunicacionProcedimiento locale Locale con el idioma
	 * seleccionado en la aplicacion ApplicantInfo.
	 *
	 * @param comunicacion
	 *            the comunicacion
	 * @param locale
	 *            the locale
	 * @return the applicant info context submission
	 */
	protected abstract ApplicantInfo getApplicantInfoContextSubmission(
			ComunicacionProcedimiento comunicacion, Locale locale);

}
